/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.SFPSelectServiceableEventsBean;
import com.ibm.hsc.auiml.databeans.sfp.data.CSPError;
import com.ibm.hsc.auiml.databeans.sfp.data.ManagedObject;
import com.ibm.hsc.auiml.databeans.sfp.data.ServiceableEvent;
import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.command.HMCFormatTable;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.websm.sfp.SelectServiceableEvent;
import com.ibm.hwmca.common.HException;
import com.ibm.hwmca.common.log.Log;
import com.ibm.hwmca.common.log.SystemEventLog;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;

public class HMCEventsList
implements HMCCommands {
    private static final String NAME_FORMAT = "name";
    private static final String TIME_FORMAT = "time";
    private static final String CALLHOME_FORMAT = "callhome";
    private static final String CALLEDHOME_FORMAT = "calledhome";
    private static final String ERRORCLASS_FORMAT = "errorclass";
    private static final String DESCRIPTION_FORMAT = "description";
    private static final String RSRCHANDLE_FORMAT = "rsrchandle";
    private static final String FIRSTTIME_FORMAT = "first_time";
    private static final String LASTTIME_FORMAT = "last_time";
    private static final String CREATEDTIME_FORMAT = "created_time";
    private static final String STATUS_FORMAT = "status";
    private static final String[] validHardware = new String[]{"name", "time", "callhome", "calledhome", "errorclass", "description", "rsrchandle", "first_time", "last_time", "created_time", "status"};
    private static final String[] validConsole = new String[]{"time", "description"};
    private static final String CONSOLE_PARAM = "console";
    private static final String HARDWARE_PARAM = "hardware";
    private static final String LPAR_PARAM = "lpar";
    private static final String SP_PARAM = "sp";
    private static final String ALL_PARAM = "ALL";
    private int formatCount;
    private String[] formatOrder;
    private String formatDelim;
    private boolean consoleEvents;
    private boolean serviceableEvents;
    private int numDays;
    private int numMins;
    private String sourceSpec;
    private String sourcePartition;
    private String managedSystem;
    private String switchMTMS;
    private boolean switchEvents;
    private boolean CECEvents;
    private HSCCECClient hcc;
    private HSCLPARClient hlc;

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        Object var2_2 = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        this.hcc = this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
        if (null == this.hcc) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
            throw new HSCException(string);
        }
        if (this.sourceSpec.equals(LPAR_PARAM)) {
            this.hlc = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.sourcePartition, false);
            if (null == this.hlc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        String string = "";
        HMCFormatTable hMCFormatTable = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy hh:mm:ss a", new Locale("en", "US"));
        if (this.consoleEvents) {
            object3 = null;
            object2 = Calendar.getInstance();
            ((Calendar)object2).setTime(new Date());
            if (this.numDays == 0 && this.numMins != 0) {
                ((Calendar)object2).add(12, -this.numMins);
            } else {
                ((Calendar)object2).add(5, -this.numDays);
                ((Calendar)object2).set(14, 0);
                ((Calendar)object2).set(13, 0);
                ((Calendar)object2).set(12, 0);
                ((Calendar)object2).set(11, 0);
            }
            object = ((Calendar)object2).getTime();
            try {
                object3 = Log.retrieve((Byte)new Byte(0), null, null, (Date)object, null, null, null, null);
            }
            catch (HException hException) {
                throw new HSCException(hException);
            }
            if (object3 == null || ((Object)object3).length == 0) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND");
                throw new HSCException(string);
            }
            stringArray = new String[2];
            if (this.formatCount == 0) {
                hMCFormatTable = new HMCFormatTable(2);
                stringArray[0] = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "TIMESTAMP");
                stringArray[1] = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "DESCRIPTION");
                hMCFormatTable.addEntry(stringArray);
            }
            int n = 0;
            while (n < ((Object)object3).length) {
                stringArray[0] = simpleDateFormat.format(object3[n].getTimestamp());
                try {
                    stringArray[1] = new SystemEventLog((Log)object3[n]).getEventText().toString();
                }
                catch (MissingResourceException missingResourceException) {
                    stringArray[1] = "";
                }
                stringArray[1] = stringArray[1] == null ? "" : stringArray[1].replace('\n', ' ');
                if (this.formatCount == 0) {
                    hMCFormatTable.addEntry(stringArray);
                } else {
                    int n2 = 0;
                    while (n2 < this.formatCount) {
                        if (this.formatOrder[n2].equals(TIME_FORMAT)) {
                            System.out.print(stringArray[0]);
                        } else if (this.formatOrder[n2].equals(DESCRIPTION_FORMAT)) {
                            System.out.print(stringArray[1]);
                        }
                        System.out.print(this.formatDelim);
                        ++n2;
                    }
                    System.out.println();
                }
                ++n;
            }
        } else if (this.serviceableEvents) {
            Comparable<StringBuffer> comparable;
            int n;
            object3 = SFPSelectServiceableEventsBean.ALL_LABEL;
            object2 = SFPSelectServiceableEventsBean.ALL_LABEL;
            object = SFPSelectServiceableEventsBean.ALL_LABEL;
            if (this.CECEvents) {
                this.initializeClients();
                object3 = this.hcc.getIntName();
                if (this.sourceSpec.equals(LPAR_PARAM)) {
                    String string2 = this.hlc.getIntName();
                    object2 = string2.substring(0, string2.indexOf(42));
                } else if (this.sourceSpec.equals(SP_PARAM)) {
                    object2 = SFPSelectServiceableEventsBean.CSP_LABEL;
                }
            } else {
                object = "HMC";
                if (!this.switchMTMS.equals(ALL_PARAM)) {
                    object3 = this.switchMTMS;
                }
            }
            if (!((String)object3).equals(SFPSelectServiceableEventsBean.ALL_LABEL) && (n = ((String)object3).lastIndexOf(42)) >= 0) {
                comparable = new StringBuffer((String)object3);
                ((StringBuffer)comparable).setCharAt(n, '/');
                object3 = ((StringBuffer)comparable).toString();
            }
            stringArray = new Integer(this.numDays);
            comparable = new Integer(this.numMins);
            ServiceableEvent[] serviceableEventArray = null;
            try {
                serviceableEventArray = SelectServiceableEvent.getMatchingServiceableEvents((Integer)stringArray, comparable, (String)object3, (String)object2, (String)object, SFPSelectServiceableEventsBean.ALL_LABEL, SFPSelectServiceableEventsBean.ALL_LABEL, SFPSelectServiceableEventsBean.ALL_LABEL, SFPSelectServiceableEventsBean.ALL_LABEL, SFPSelectServiceableEventsBean.ALL_LABEL, Boolean.FALSE);
            }
            catch (SFPException sFPException) {
                throw new HSCException(HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", sFPException.getKey()));
            }
            if (serviceableEventArray == null || serviceableEventArray.length == 0) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND");
                throw new HSCException(string);
            }
            String[] stringArray2 = new String[10];
            String string3 = "";
            String string4 = "";
            if (this.formatCount == 0) {
                string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "YES");
                string4 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO");
                hMCFormatTable = new HMCFormatTable(6);
                stringArray2[0] = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM");
                stringArray2[1] = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "TIMESTAMP");
                stringArray2[2] = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CALL_HOME");
                stringArray2[3] = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CALLED_HOME");
                stringArray2[4] = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ERROR_CLASS");
                stringArray2[5] = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "DESCRIPTION");
                hMCFormatTable.addEntry(stringArray2);
            } else {
                string3 = "1";
                string4 = "0";
            }
            int n3 = 0;
            while (n3 < serviceableEventArray.length) {
                String string5;
                ManagedObject[] managedObjectArray = serviceableEventArray[n3].getManagedObjects();
                stringArray2[0] = managedObjectArray[0].getMachineName();
                stringArray2[1] = serviceableEventArray[n3].getEarliestOriginalTimestamp();
                stringArray2[2] = serviceableEventArray[n3].isCallHomeCandidate() ? string3 : string4;
                stringArray2[3] = serviceableEventArray[n3].isCalledHome() ? string3 : string4;
                stringArray2[4] = managedObjectArray[0].getErrorClass();
                stringArray2[5] = managedObjectArray[0].getErrorText();
                if ((stringArray2[5] == null || stringArray2[5].equals("")) && ((string5 = managedObjectArray[0].getPartitionId()) == null || string5.equals(""))) {
                    CSPError[] cSPErrorArray = managedObjectArray[0].getCSPErrors();
                    int n4 = 0;
                    while (n4 < cSPErrorArray.length) {
                        stringArray2[5] = cSPErrorArray[n4].getErrorText();
                        if (stringArray2[5] != null && !stringArray2[5].equals("")) break;
                        ++n4;
                    }
                }
                stringArray2[5] = stringArray2[5] == null ? "" : stringArray2[5].replace('\n', ' ');
                stringArray2[6] = serviceableEventArray[n3].getResourceHandle().toString();
                stringArray2[7] = serviceableEventArray[n3].getLatestTimestamp();
                stringArray2[8] = managedObjectArray[0].getCreatedTimestamp();
                stringArray2[9] = serviceableEventArray[n3].getStatus();
                if (this.formatCount == 0) {
                    hMCFormatTable.addEntry(stringArray2);
                } else {
                    int n5 = 0;
                    while (n5 < this.formatCount) {
                        if (this.formatOrder[n5].equals(NAME_FORMAT)) {
                            System.out.print(stringArray2[0]);
                        } else if (this.formatOrder[n5].equals(TIME_FORMAT) || this.formatOrder[n5].equals(FIRSTTIME_FORMAT)) {
                            System.out.print(stringArray2[1]);
                        } else if (this.formatOrder[n5].equals(CALLHOME_FORMAT)) {
                            System.out.print(stringArray2[2]);
                        } else if (this.formatOrder[n5].equals(CALLEDHOME_FORMAT)) {
                            System.out.print(stringArray2[3]);
                        } else if (this.formatOrder[n5].equals(ERRORCLASS_FORMAT)) {
                            System.out.print(stringArray2[4]);
                        } else if (this.formatOrder[n5].equals(DESCRIPTION_FORMAT)) {
                            System.out.print(stringArray2[5]);
                        } else if (this.formatOrder[n5].equals(RSRCHANDLE_FORMAT)) {
                            System.out.print(stringArray2[6]);
                        } else if (this.formatOrder[n5].equals(LASTTIME_FORMAT)) {
                            System.out.print(stringArray2[7]);
                        } else if (this.formatOrder[n5].equals(CREATEDTIME_FORMAT)) {
                            System.out.print(stringArray2[8]);
                        } else if (this.formatOrder[n5].equals(STATUS_FORMAT)) {
                            System.out.print(stringArray2[9]);
                        }
                        System.out.print(this.formatDelim);
                        ++n5;
                    }
                    System.out.println();
                }
                ++n3;
            }
        }
        if (hMCFormatTable != null) {
            object3 = hMCFormatTable.getTable();
            int n = 0;
            while (n < ((String[])object3).length) {
                System.out.println(object3[n]);
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String[] stringArray = null;
        int n = 0;
        int n2 = 0;
        this.consoleEvents = false;
        this.serviceableEvents = false;
        this.switchEvents = false;
        this.CECEvents = false;
        this.numDays = 7;
        this.numMins = 0;
        this.managedSystem = null;
        this.sourcePartition = null;
        this.sourceSpec = null;
        this.formatCount = 0;
        this.formatOrder = null;
        string3 = (String)hashMap.get(HMCCommandUtils.TYPE_PARAM);
        string4 = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        string5 = (String)hashMap.get(HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM);
        this.sourceSpec = (String)hashMap.get(HMCCommandUtils.SOURCE_PARAM);
        this.switchMTMS = (String)hashMap.get(HMCCommandUtils.SWITCH_PARAM);
        string6 = (String)hashMap.get(HMCCommandUtils.DAYS_PARAM);
        string7 = (String)hashMap.get("-i");
        if (string3 == null) {
            Object[] objectArray = new String[]{HMCCommandUtils.TYPE_PARAM};
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string2);
        }
        string3 = string3.trim();
        n2 = 1;
        if (string3.equals(CONSOLE_PARAM)) {
            this.consoleEvents = true;
            stringArray = validConsole;
            n = validConsole.length;
            if (string4 != null) {
                ++n2;
            }
            if (string5 != null) {
                ++n2;
            }
            if (this.sourceSpec != null) {
                ++n2;
            }
        } else {
            if (!string3.equals(HARDWARE_PARAM)) {
                Object[] objectArray = new String[]{HMCCommandUtils.TYPE_PARAM, "console, hardware"};
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                throw new RequiredParameterException(string2);
            }
            this.serviceableEvents = true;
            stringArray = validHardware;
            n = validHardware.length;
            if (string4 != null) {
                this.CECEvents = true;
            }
            if (this.switchMTMS != null) {
                this.switchEvents = true;
            }
            if (this.CECEvents && this.switchEvents) {
                Object[] objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM, HMCCommandUtils.SWITCH_PARAM};
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_CONFLICT_ARGS", null, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (this.CECEvents) {
                this.managedSystem = string4.trim();
                ++n2;
                if (this.sourceSpec == null) {
                    Object[] objectArray = new String[]{HMCCommandUtils.TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.SOURCE_PARAM};
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                    throw new RequiredParameterException(string2);
                }
                ++n2;
                this.sourceSpec = this.sourceSpec.trim();
                if (!this.sourceSpec.equals(ALL_PARAM) && !this.sourceSpec.equals(SP_PARAM)) {
                    if (!this.sourceSpec.equals(LPAR_PARAM)) {
                        Object[] objectArray = new String[]{HMCCommandUtils.SOURCE_PARAM, "ALL, lpar, sp"};
                        string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                        throw new RequiredParameterException(string2);
                    }
                    if (string5 == null) {
                        Object[] objectArray = new String[]{HMCCommandUtils.TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.SOURCE_PARAM + ", " + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM};
                        string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                        throw new RequiredParameterException(string2);
                    }
                    this.sourcePartition = string5.trim();
                    ++n2;
                }
            } else {
                if (!this.switchEvents) {
                    Object[] objectArray = new String[]{HMCCommandUtils.TYPE_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND_EITHER") + " " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR") + " " + HMCCommandUtils.SWITCH_PARAM};
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                    throw new RequiredParameterException(string2);
                }
                this.switchMTMS = this.switchMTMS.trim();
                ++n2;
            }
        }
        if (string6 != null) {
            this.numDays = Integer.parseInt(string6);
            if (this.serviceableEvents && this.numDays > 90) {
                Object[] objectArray;
                objectArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NUMBER_OF_DAYS"), objectArray[0], "0-90"};
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_VALUE", null, objectArray);
                throw new RequiredParameterException(string2);
            }
            ++n2;
        }
        if (string7 != null) {
            if (string6 != null) {
                Object[] objectArray = new String[]{"-i", HMCCommandUtils.DAYS_PARAM};
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_CONFLICT_ARGS", null, objectArray);
                throw new RequiredParameterException(string2);
            }
            this.numDays = 0;
            this.numMins = Integer.parseInt(string7);
            if (this.numMins <= 0) {
                Object[] objectArray = new String[]{"-i", "> 0"};
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray);
                throw new RequiredParameterException(string2);
            }
            ++n2;
        }
        if ((string = (String)hashMap.get(HMCCommandUtils.FORMAT_PARAM)) != null) {
            this.formatDelim = HMCCommandUtils.getFormatDelimiter(string, stringArray, n);
            this.formatOrder = HMCCommandUtils.parseFormatList(string, this.formatDelim, stringArray, n);
            this.formatCount = this.formatOrder.length;
            ++n2;
        }
        HMCCommandUtils.checkParameterCount(hashMap, n2);
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "HMCEVENTS_LIST_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        HMCEventsList hMCEventsList = new HMCEventsList();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                hMCEventsList.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    hMCEventsList.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                hMCEventsList.mapParameters(hashMap);
                hMCEventsList.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

